//
//  MCHostingNode.h
//  MCHosting
//
//  Created by Thomas Bartelmess on 10-10-28.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//




@protocol MCGetDatabaseConnectionSettingsInformation

- (void)gotDatabaseConnectionSettingsInformation:(NSDictionary *)databaseInfo;
- (void)failedToGetDatabaseConnectionSettings:(NSError *)error;

@end


extern NSString * kHostingSettingsFilePath;
extern NSString * kSSLCertFolderPath;

@class MCServerKeychain, MCPConnectionInfo, MCHostedServer;

@interface MCHostingNode : NSObject {
	NSMutableDictionary * responseRegistry;
	
	BOOL waitingForDatabaseList;
	NSArray* _databaseList;
	
	
	NSMutableDictionary * nextStagedJobRegistry;
    
    NSInteger numberOfNextJobs;
}

@property (nonatomic, retain) NSMutableDictionary * responseRegistry;
@property (nonatomic, retain) NSMutableDictionary * nextStagedJobRegistry;

- (void)requestDatabaseInformationForCloudAccount:(NSString *)cloudAccount delegate:(id)delegate;
- (NSArray *)allServers;

- (MCHostedServer *)hostedServerForCloudAccount:(NSString *)cloudAccount;
- (MCHostedServer *)synchronousHostedServerForCloudAccount:(NSString *)cloudAccount;


- (NSDictionary *)connectionSettingsFromLaunchArgumentsForCloudAccount:(NSString *)cloudAccount;
- (NSDictionary *)connectionSettingsForCloudAccount:(NSString *)cloudAccount;
- (NSDictionary *)synchronousConnectionSettingsForCloudAccount:(NSString *)cloudAccount httpStatusCode:(NSInteger *)statCode;
- (MCPConnectionInfo *)connectionInfoForCloudAccount:(NSString *)cloudAccount;

- (NSDictionary *)nextStagedJob;
- (void)returnStagedJob:(NSString *)jobUUID success:(BOOL)success;

+ (MCServerKeychain *)serverKeychain;

+ (Class)hostingNodeClass;
+ (void)setHostingNodeClass:(Class)aClass;

// Abstract 
- (Class)hostedServerClass;

@end
